/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.tabs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class SimpleTabPaneUI
extends BasicTabbedPaneUI {
    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.tabPane.getBackgroundAt(tabIndex));
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y, w - 1, h - 2);
                break;
            }
            case 3: {
                g.fillRect(x, y, w - 2, h - 1);
                break;
            }
            default: {
                g.fillRect(x, y, w - 2, h - 2);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        super.paint(g, c);
        g.setColor(this.tabPane.getBackgroundAt(this.tabPane.getSelectedIndex()));
        g.fillRect(this.tabPane.getX(), 0, this.tabPane.getWidth(), 2);
        g.setColor(this.tabPane.getComponentAt(this.tabPane.getSelectedIndex()).getBackground());
        g.fillRect(this.tabPane.getX(), this.calculateTabAreaHeight(this.tabPane.getTabPlacement(), this.runCount, this.maxTabHeight) - this.getTabAreaInsets((int)0).bottom, this.tabPane.getWidth(), this.getTabAreaInsets((int)0).bottom);
        this.drawTriangle(g);
    }

    private void drawTriangle(Graphics g) {
        Polygon triangle = new Polygon();
        Rectangle tabRect = this.rects[this.tabPane.getSelectedIndex()];
        int y = tabRect.y;
        int x = tabRect.x;
        int w = tabRect.width;
        int h = tabRect.height;
        switch (this.tabPane.getTabPlacement()) {
            case 2: {
                int height = y + (h - 2) / 2;
                triangle.addPoint(x + w, height - 5);
                triangle.addPoint(x + w, height + 5);
                triangle.addPoint(x + w + 8, height);
                break;
            }
            case 4: {
                int height = y + (h - 2) / 2;
                triangle.addPoint(x, height - 5);
                triangle.addPoint(x, height + 5);
                triangle.addPoint(x - 8, height);
                break;
            }
            case 3: {
                int width = x + (w - 2) / 2;
                triangle.addPoint(width - 5, y);
                triangle.addPoint(width + 5, y);
                triangle.addPoint(width, y - 8);
                break;
            }
            default: {
                int width = x + (w - 2) / 2;
                triangle.addPoint(width - 6, y + h - 2);
                triangle.addPoint(width + 6, y + h - 2);
                triangle.addPoint(width, y + h + 6);
                break;
            }
        }
        g.setColor(this.tabPane.getBackgroundAt(this.tabPane.getSelectedIndex()));
        g.fillPolygon(triangle);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets startInsets = new Insets(2, 0, 8, 0);
        Insets endInsets = new Insets(0, 0, 0, 0);
        SimpleTabPaneUI.rotateInsets(startInsets, endInsets, tabPlacement);
        return endInsets;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return new Insets(8, 16, 6, 16);
    }
}

