/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.lang;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.ui.lang.IRelocalizableResource;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class ResourceLoader {
    private final Collection<IRelocalizableResource> resources = new LinkedList<IRelocalizableResource>();
    private ResourceBundle stringData;
    private Locale currentLocale;
    private final String dottedResourcePath;
    private final String slashResourcePath;
    private boolean isDefaultLocaleSupported = true;
    private final Locale defaultLocale;
    private File launcherAssets;
    private Locale[] locales = new Locale[]{Locale.ENGLISH};
    public static final String DEFAULT_LOCALE = "default";
    public static final String FONT_OPENSANS = "OpenSans+Cyberbit.ttf";
    public static final String FONT_RALEWAY = "Raleway+FireflySung.ttf";
    private static final Map<String, Font> fontCache = new HashMap<String, Font>();
    public static final Font fallbackFont = new Font("SansSerif", 0, 12);

    public void setSupportedLanguages(Locale[] locales) {
        this.locales = (Locale[])locales.clone();
    }

    public List<Locale> getSupportedLanguages() {
        return Collections.unmodifiableList(Arrays.asList(this.locales));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Font getFontByName(String fontName) {
        Font font;
        if (fontCache.containsKey(fontName)) {
            return fontCache.get(fontName);
        }
        if (this.launcherAssets == null) {
            return fallbackFont;
        }
        try {
            try (FileInputStream fontStream = FileUtils.openInputStream(new File(this.launcherAssets, fontName));){
                if (fontStream == null) {
                    Font font2 = fallbackFont;
                    return font2;
                }
                font = Font.createFont(0, fontStream);
            }
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            genv.registerFont(font);
        }
        catch (Exception e) {
            e.printStackTrace();
            return fallbackFont;
        }
        fontCache.put(fontName, font);
        if (font != null) return font;
        return fallbackFont;
    }

    public ResourceLoader(LauncherDirectories directories, String ... resourcesPath) {
        this.launcherAssets = directories == null ? null : new File(directories.getAssetsDirectory(), "launcher");
        this.dottedResourcePath = Arrays.stream(resourcesPath).collect(Collectors.joining(".", "", "."));
        this.slashResourcePath = Arrays.stream(resourcesPath).collect(Collectors.joining("/", "/", ""));
        Locale systemDefaultLocale = Locale.getDefault();
        this.defaultLocale = this.matchClosestSupportedLocale(systemDefaultLocale);
        if (!this.defaultLocale.getLanguage().equals(systemDefaultLocale.getLanguage())) {
            this.isDefaultLocaleSupported = false;
        }
        if (this.launcherAssets != null) {
            for (String font : new String[]{FONT_OPENSANS, FONT_RALEWAY}) {
                File fontFile = new File(this.launcherAssets, font);
                if (fontFile.exists()) continue;
                try (InputStream fontStream = this.getResourceAsStream("/font/" + font);){
                    if (fontStream == null) {
                        Utils.getLogger().log(Level.SEVERE, "Font file not found: " + font);
                        continue;
                    }
                    FileUtils.copyInputStreamToFile(fontStream, fontFile);
                }
                catch (IOException ex) {
                    Utils.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        } else {
            Utils.getLogger().log(Level.WARNING, "LauncherAssets directory is null. Font files will not be created.");
        }
    }

    public ResourceLoader(ResourceLoader resourceLoader) {
        this.dottedResourcePath = resourceLoader.dottedResourcePath;
        this.slashResourcePath = resourceLoader.slashResourcePath;
        this.defaultLocale = resourceLoader.defaultLocale;
        this.isDefaultLocaleSupported = resourceLoader.isDefaultLocaleSupported;
        this.stringData = resourceLoader.stringData;
        this.currentLocale = resourceLoader.currentLocale;
        this.locales = resourceLoader.locales;
        this.launcherAssets = resourceLoader.launcherAssets;
    }

    public boolean isDefaultLocaleSupported() {
        return this.isDefaultLocaleSupported;
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
        this.stringData = ResourceBundle.getBundle(this.dottedResourcePath + "lang.UIText", locale);
        this.relocalizeResources();
    }

    public void setLocale(String locale) {
        this.setLocale(this.getLocaleFromCode(locale));
    }

    public ResourceLoader getVariant(Locale locale) {
        ResourceLoader variant = new ResourceLoader(this);
        variant.setSupportedLanguages(this.locales);
        variant.setLocale(locale);
        return variant;
    }

    public String getString(String stringKey, String ... replacements) {
        String outString = this.stringData.getString(stringKey);
        for (int i = 0; i < replacements.length; ++i) {
            String find = String.format("{%d}", i);
            String replace = replacements[i];
            if (replace == null) {
                throw new IllegalArgumentException("Replacement string cannot be null");
            }
            if (!outString.contains(find)) continue;
            outString = outString.replace(find, replace);
        }
        return outString;
    }

    public String getCodeFromLocale(Locale locale) {
        if (locale.getLanguage().isEmpty()) {
            return DEFAULT_LOCALE;
        }
        if (locale.getCountry().isEmpty()) {
            return locale.getLanguage();
        }
        if (locale.getVariant().isEmpty()) {
            return String.format("%s,%s", locale.getLanguage(), locale.getCountry());
        }
        return String.format("%s,%s,%s", locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public Locale getLocaleFromCode(String localeCode) {
        if (localeCode == null || localeCode.isEmpty() || localeCode.equals(DEFAULT_LOCALE)) {
            return this.defaultLocale;
        }
        String[] results = localeCode.split(",");
        String language = "";
        String country = "";
        String variant = "";
        if (results.length > 0) {
            language = results[0];
        }
        if (results.length > 1) {
            country = results[1];
        }
        if (results.length > 2) {
            variant = results[2];
        }
        Locale definiteLocale = new Locale(language, country, variant);
        return this.matchClosestSupportedLocale(definiteLocale);
    }

    private Locale matchClosestSupportedLocale(Locale definiteLocale) {
        Locale bestSupportedLocale = null;
        int bestLocaleScore = 0;
        for (Locale testLocale : this.locales) {
            int testScore = 0;
            if (testLocale.getLanguage().equals(definiteLocale.getLanguage())) {
                ++testScore;
                if (testLocale.getCountry().equals(definiteLocale.getCountry())) {
                    ++testScore;
                    if (testLocale.getVariant().equals(definiteLocale.getVariant())) {
                        ++testScore;
                    }
                }
            }
            if (testScore == 0 || testScore <= bestLocaleScore) continue;
            bestLocaleScore = testScore;
            bestSupportedLocale = testLocale;
        }
        if (bestSupportedLocale != null) {
            return bestSupportedLocale;
        }
        return Locale.getDefault();
    }

    public boolean hasResource(String name) {
        return ResourceLoader.class.getResource(this.getResourcePath("/" + name)) != null;
    }

    public ImageIcon getIcon(String iconName) {
        return new ImageIcon(ResourceLoader.class.getResource(this.getResourcePath("/" + iconName)));
    }

    public BufferedImage getImage(String imageName) {
        try {
            return ImageIO.read(ResourceLoader.class.getResourceAsStream(this.getResourcePath("/" + imageName)));
        }
        catch (IOException ex) {
            Utils.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        return ResourceLoader.class.getResourceAsStream(this.getResourcePath(path));
    }

    public BufferedImage getCircleClippedImage(String imageName) {
        BufferedImage contentImage = this.getImage(imageName);
        return this.getCircleClippedImage(contentImage);
    }

    public BufferedImage colorImage(BufferedImage loadImg, Color color) {
        BufferedImage img = new BufferedImage(loadImg.getWidth(), loadImg.getHeight(), 3);
        Graphics2D graphics = img.createGraphics();
        graphics.setColor(color);
        graphics.drawImage(loadImg, null, 0, 0);
        graphics.setComposite(AlphaComposite.getInstance(5, 1.0f));
        graphics.fillRect(0, 0, loadImg.getWidth(), loadImg.getHeight());
        graphics.dispose();
        return img;
    }

    public BufferedImage getCircleClippedImage(BufferedImage contentImage) {
        BufferedImage outputImage = new BufferedImage(contentImage.getWidth(), contentImage.getHeight(), 2);
        Graphics2D g2 = (Graphics2D)outputImage.getGraphics();
        g2.drawImage((Image)contentImage, 0, 0, null);
        Area cutOutArea = new Area(new Rectangle(0, 0, outputImage.getWidth(), outputImage.getHeight()));
        int diameter = Math.min(outputImage.getWidth(), outputImage.getHeight());
        cutOutArea.subtract(new Area(new Ellipse2D.Float((float)(outputImage.getWidth() - diameter) / 2.0f, (float)(outputImage.getHeight() - diameter) / 2.0f, diameter, diameter)));
        g2.setColor(Color.WHITE);
        g2.setComposite(AlphaComposite.Clear);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(cutOutArea);
        g2.dispose();
        return outputImage;
    }

    public Font getFont(String name, float size) {
        return this.getFont(name, size, 0);
    }

    public Font getFont(String name, float size, int style) {
        return this.getFontByName(name).deriveFont(style, size);
    }

    private void relocalizeResources() {
        for (IRelocalizableResource resource : this.resources) {
            resource.relocalize(this);
        }
    }

    private String getResourcePath(String resource) {
        return this.slashResourcePath + resource;
    }

    public void registerResource(IRelocalizableResource resource) {
        if (!this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    public void unregisterResource(IRelocalizableResource resource) {
        this.resources.remove(resource);
    }
}

