/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.utilslib;

import java.io.File;
import java.nio.file.FileSystems;
import java.util.Locale;

public enum OperatingSystem {
    LINUX("linux", new String[]{"linux", "unix"}),
    WINDOWS("windows", new String[]{"win"}),
    OSX("osx", new String[]{"mac"}),
    UNKNOWN("unknown", new String[0]);

    private static OperatingSystem operatingSystem;
    private final String name;
    private final String[] aliases;

    private OperatingSystem(String name, String[] aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    public static String getJavaDir() {
        String separator = FileSystems.getDefault().getSeparator();
        String path = System.getProperty("java.home") + separator + "bin" + separator;
        if (OperatingSystem.getOperatingSystem() == WINDOWS) {
            return path + "javaw.exe";
        }
        return path + "java";
    }

    public static OperatingSystem getOperatingSystem() {
        if (operatingSystem != null) {
            return operatingSystem;
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        for (OperatingSystem operatingSystem : OperatingSystem.values()) {
            for (String alias : operatingSystem.getAliases()) {
                if (!osName.contains(alias)) continue;
                OperatingSystem.operatingSystem = operatingSystem;
                return operatingSystem;
            }
        }
        return UNKNOWN;
    }

    public File getUserDirectoryForApp(String appName) {
        String userHome = System.getProperty("user.home", ".");
        switch (this) {
            case LINUX: {
                return new File(userHome, "." + appName + "/");
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    return new File(applicationData, "." + appName + "/");
                }
                return new File(userHome, "." + appName + "/");
            }
            case OSX: {
                return new File(userHome, "Library/Application Support/" + appName);
            }
        }
        return new File(userHome, appName + "/");
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getName() {
        return this.name;
    }
}

