/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.utilslib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntime;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntimeAdapter;
import net.technicpack.launchercore.mirror.download.Download;
import net.technicpack.launchercore.util.DownloadListener;
import net.technicpack.utilslib.ProcessUtils;
import org.apache.commons.io.FileUtils;

public class Utils {
    private static final Gson gson;
    private static final Logger logger;
    private static final int DOWNLOAD_RETRIES = 3;

    public static Gson getGson() {
        return gson;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static HttpURLConnection openHttpConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(false);
        System.setProperty("http.agent", TechnicConstants.getUserAgent());
        conn.setRequestProperty("User-Agent", TechnicConstants.getUserAgent());
        conn.setUseCaches(false);
        return conn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean pingHttpURL(String urlLoc) {
        boolean bl;
        URL url = Utils.getFullUrl(urlLoc);
        HttpURLConnection conn = Utils.openHttpConnection(url);
        conn.setRequestMethod("HEAD");
        int responseCode = conn.getResponseCode();
        int responseFamily = responseCode / 100;
        if (responseFamily == 3) {
            URL redirectUrl;
            String newUrl = conn.getHeaderField("Location");
            try {
                redirectUrl = new URL(newUrl);
            }
            catch (MalformedURLException ex) {
                throw new DownloadException("Invalid Redirect URL: " + url, ex);
            }
            conn = Utils.openHttpConnection(redirectUrl);
            responseCode = conn.getResponseCode();
            responseFamily = responseCode / 100;
        }
        if (responseFamily != 2) return false;
        InputStream stream = conn.getInputStream();
        try {
            bl = true;
            if (stream == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Got an error when pinging " + urlLoc, ex);
                return false;
            }
        }
        stream.close();
        return bl;
    }

    public static boolean sendTracking(String category, String action, String label, String clientId) {
        return true;
    }

    public static String getProcessOutput(String ... command) {
        String out = null;
        try {
            ProcessBuilder pb = ProcessUtils.createProcessBuilder(command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            StringBuilder response = new StringBuilder();
            Thread outputThread = new Thread(() -> {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        response.append(line).append('\n');
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            outputThread.start();
            process.waitFor();
            outputThread.join();
            if (response.length() > 0) {
                out = response.toString().trim();
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (InterruptedException ex) {
            return null;
        }
        return out;
    }

    public static URL getFullUrl(String url) throws DownloadException {
        URL urlObject;
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new DownloadException("Invalid URL: " + url, ex);
        }
        return urlObject;
    }

    public static String getETag(String address) {
        String md5 = "";
        try {
            URL url = Utils.getFullUrl(address);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(false);
            System.setProperty("http.agent", TechnicConstants.getUserAgent());
            conn.setRequestProperty("User-Agent", TechnicConstants.getUserAgent());
            HttpURLConnection.setFollowRedirects(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            String eTag = conn.getHeaderField("ETag");
            if (eTag != null && (eTag = eTag.replaceAll("^\"|\"$", "")).length() == 32) {
                md5 = eTag;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return md5;
    }

    public static Download downloadFile(String url, String name, String output, File cache, IFileVerifier verifier, DownloadListener listener) throws IOException, InterruptedException {
        int tries = 3;
        File outputFile = null;
        Download download = null;
        while (tries > 0) {
            Utils.getLogger().info("Starting download of " + url + ", with " + tries + " tries remaining");
            --tries;
            download = new Download(Utils.getFullUrl(url), name, output);
            download.setListener(listener);
            download.run();
            if (download.getResult() != Download.Result.SUCCESS) {
                if (download.getOutFile() != null) {
                    download.getOutFile().delete();
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                Utils.getLogger().log(Level.WARNING, String.format("Download of %s failed!", url), download.getException());
                if (listener == null) continue;
                listener.stateChanged("Download failed, retries remaining: " + tries, 0.0f);
                continue;
            }
            if (!download.getOutFile().exists() || verifier != null && !verifier.isFileValid(download.getOutFile())) continue;
            outputFile = download.getOutFile();
            break;
        }
        if (outputFile == null) {
            throw new DownloadException("Failed to download " + url, download.getException());
        }
        if (cache != null) {
            FileUtils.copyFile(outputFile, cache);
        }
        return download;
    }

    public static Download downloadFile(String url, String name, String output, File cache) throws IOException, InterruptedException {
        return Utils.downloadFile(url, name, output, cache, null, null);
    }

    public static Download downloadFile(String url, String name, String output) throws IOException, InterruptedException {
        return Utils.downloadFile(url, name, output, null);
    }

    static {
        logger = Logger.getLogger("net.technicpack.launcher.Main");
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter((Type)((Object)FileBasedJavaRuntime.class), new FileBasedJavaRuntimeAdapter());
        gson = builder.create();
        logger.setLevel(Level.ALL);
    }
}

